/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.comm;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ImageFileDataTransfer
extends DataTransfer {
    private final int SETTING_AREA_SIZE = 512;
    private final int IMAGE_FILE_SIZE = 65536;
    private final int MODULE_ID_INDEX = 0;
    private final int PASSWORD_FLAG_INDEX = 1;
    private final int OHC_EXISTED_INDEX = 2;
    private final int DISPLAY_TRANSFER_ON_INDEX = 3;
    private final int IMAGE_FILE_CHECKSUM = 511;
    private final int INVALID_INDEX = 255;
    private byte[] settingArr = new byte[512];
    private byte[] imageArr = new byte[65536];

    public void closePort() {
    }

    public int readByte(int adr) throws TransmissionFailedException {
        if (adr < 65536) {
            return this.readByteFromImageArea(adr);
        }
        return this.readByteFromSettingArea(adr);
    }

    private int readByteFromImageArea(int adr) {
        this.fLastAddress = adr;
        return this.imageArr[adr];
    }

    private int readByteFromSettingArea(int adr) {
        int newAdr = adr & 0xFFFF;
        int settingAdr = this.getSettingAdr(newAdr);
        return this.settingArr[settingAdr];
    }

    public int readNextByte() throws TransmissionFailedException {
        this.nextAddress();
        return this.readByte(this.fLastAddress);
    }

    public void writeBinToOutputStream(FileOutputStream outputStream) throws IOException {
        outputStream.write(this.settingArr);
        outputStream.write(this.imageArr);
    }

    public void readBinFromFileInputStream(FileInputStream inputStream) throws IOException {
        inputStream.read(this.settingArr);
        inputStream.read(this.imageArr);
    }

    protected void writeByte(int adr, int writeValue, int timeout) throws TransmissionFailedException {
        if (adr < 65536) {
            this.writeByteToImageArea(adr, writeValue);
        } else {
            this.writeByteToSettingArea(adr, writeValue);
        }
    }

    private void writeByteToImageArea(int adr, int writeValue) {
        this.fLastAddress = adr;
        this.imageArr[adr] = (byte)writeValue;
    }

    private void writeByteToSettingArea(int adr, int writeValue) {
        if (adr == 16728320 || adr == 16728576) {
            return;
        }
        int newAdr = adr & 0xFFFF;
        int settingAdr = this.getSettingAdr(newAdr);
        this.settingArr[settingAdr] = (byte)writeValue;
    }

    private int getSettingAdr(int newAdr) {
        if (newAdr == 7936) {
            return 0;
        }
        if (newAdr == 18687) {
            return 1;
        }
        if (newAdr == 17324) {
            return 2;
        }
        if (newAdr == 18240) {
            return 3;
        }
        return 255;
    }

    public void writeNextByte(int value) throws TransmissionFailedException {
        this.nextAddress();
        this.writeByte(this.fLastAddress, (byte)value);
    }

    protected int getReadByteRetryTimes() {
        return 0;
    }

    public int uploadHardwareID() throws TransmissionFailedException {
        int moduleID = this.settingArr[0];
        if ((moduleID = 0x70 & moduleID) == 16) {
            return 80;
        }
        return 255;
    }

    public void writeHardwareID(int hardwareID) throws TransmissionFailedException {
        if (hardwareID == 80) {
            this.writeByteToSettingArea(0xFF1F00, 16);
        }
    }

    public void writeChecksumForSettingArea() {
        byte checksum = 0;
        for (int i = 0; i < 511; ++i) {
            checksum = (byte)(checksum + this.settingArr[i]);
        }
        this.settingArr[511] = checksum;
    }

    protected void resetInternalWait() {
    }

    public String toString() {
        return Language.getString("msg.com.GenerateImageFile", "Data transfer for generating image file ");
    }

    public void rebuildConnection() throws ExceptionAlreadyHandledException {
    }
}

